<?php

/**
 * Aceasta este o implementare pentru cel mai simplu template engine
 * Implementarea este EXTREM de ne-eficienta, si exista doar cu scop didactic
 * Ideea este luata de aici: http://www.webmasterworld.com/php/3444822.htm
 * 
 * @author yeti
 *
 */
class TemplateEngine {
	
	
	public $parts;
	public $file;
	
	public function __construct($file, $parts) {
		$this->parts = $parts;
		$this->file = $file;
	}
	
	/**
	 * Aceasta metoda inlocuieste orice {nume} din $this->file cu $this->parts['nume']
	 * @return String rezultatul inlocuirii 
	 */
	public function render_to_string() {
		$parts = $this->parts;
		return preg_replace("/\{\{([^\{]{1,100}?)\}\}/e",'$parts["$1"]', file_get_contents($this->file)); 		
	}
	
	/**
	 * Metoda nu face altceva decat sa puna la iesirea PHP rezultatul functiei $this->render_to_string()
	 * @see TemplateEngine::render_to_string() 
	 * 
	 */
	public function output_to_response() {
		echo $this->render_to_string();
	}
}


//$tpl = new TemplateEngine("../html/test.html", array("test" => "hello", "link" => "world"));
//$tpl->output_to_response();