<?php

/**
 * Implementare de referinta pentru clasa Punct din laboratorul AW pentru CRUD
 * 
 * @author yeti
 *
 */
class Punct {
	
	
	public $long;
	public $lat;
	public $ssid;
	public $id;
	public $con;
	
	/**
	 * Constructorul defineste valori default (implicite) pentru parametrii - pentru a putea
	 * omite o serie de parametrii.
	 * 
	 * @param float $long longitutinde
	 * @param float $lat latitudine
	 * @param String $ssid ssid-ul retelei
	 * @param int $id id-ul inregistrarii in baza de date
	 */
	public function __construct($con = null, $long = 0, $lat = 0, $ssid = '', $id = 0) {
		$this->con = $con;
		$this->long = $long;
		$this->lat = $lat;
		$this->ssid = $ssid;
		$this->id = $id;
	}

	
	/**
	 * Metoeda populeaza informații din baza de date în membrii clasei. Aici este implementată
	 * ca o metodă a obiectului. O altă variantă este să fie implementata o metoda de tip factory
	 * 
	 * @param int $id id-ul inregistrarii in baza de date
	 */
	public function get_by_id($id) {
		$result = $this->con->query("SELECT * FROM ssid_data WHERE id = " . $id);
		if (!$result) {
			die($con->error);
		}
		
		$obj = $result->fetch_object();
		$this->long = $obj->long;
		$this->lat = $obj->lat;
		$this->ssid = $obj->ssid;
		$this->id = $id;
	}
	
	/**
	 *	Metoda salveaza obiectul in baza de date. Trateaza doua cazuri, unul in care
	 *	exista deja obiectul in baza de date si trebuie sa fie facute modificari, si al 
	 *	doilea, cand obiectul este nou si trebuie inserat.
	 *
	 *	Diferentierea se face dupa existenta campului $this->id
	 * 
	 */
	public function save() {
		if (isset($this->id)) {
			//	daca exista ID-ul, atunci obiectul exista deja in baza de date
			if (!$this->con->query(sprintf("UPDATE ssid_data SET `long` = %f, `lat` = %f, `ssid` = '%s' WHERE id = %d", $this->long, $this->lat, $this->ssid, $this->id))) {
				die ($this->con->error);
			}
		} else {
			//	daca nu exista ID-ul, atunci obiectul nu exista in baza de date si trebuie inserat
			if (!$this->con->query(sprintf("INSERT INTO ssid_data (`id`, `long`, `lat`, `ssid`) VALUES (null, %f, %f, '%s')", $this->long, $this->lat, $this->ssid))) {
				die ($this->con->error);
			}
			
			//	acum, ca obiectul exista in baza de date, trebuie sa ii sincronizam si ID-ul
			//	obiectul MySQLi are membrul last_id, care intoarce ultimul ID generat automat
			//	de o coloana AUTO_INCREMENT, cum este id, tocmai in acest scop.
			$this->id = $this->con->last_id;
		}
	}
	
	/**
	 * 
	 * Metoda sterge obiectul din baza de date. Obiectul va ramane in memorie 
	 * pana la finalizarea executiei scriptului.
	 */
	public function delete() {
		if (!isset($this->id)) {
			die ("Obiectul nu are ID!");
		}
		
		if (!$this->con->query("DELETE FROM ssid_data WHERE id = ".$this->id)) {
			die ($this->con->error);
		}
	}
	
	/**
	 * Metoda produce un string pentru afisarea intr-un Google Map,
	 * presupunand ca obiectul de tip Google Map are numele map.
	 * 
	 */
	public function get_js_string() {
		$tpl = new TemplateEngine("./html/map_part.html", array("long" => $this->long, "lat" => $this->lat, "ssid" => $this->ssid, "i" => $this->id));
		return $tpl->render_to_string();
	}

}
