<?php

require_once "php/TemplateEngine.class.php";
require_once "php/Punct.class.php";

function show_map_points($con) {
    #	obtinem informatiile despre punctele interesante din baza de date
	
    if (!($result = $con->query("SELECT * FROM ssid_data LIMIT 100"))) {
    	die ("Query error! (" . $con->connect_errno .") : " . $connect_error);
    }
    
    $str = "";
	while ($obj = $result->fetch_object()) {
		$tpl_marker = new TemplateEngine("./html/map_part.html", array("long" => $obj->long, "lat" => $obj->lat, "ssid" => $obj->ssid, "i" => $obj->id));
		$str .= $tpl_marker->render_to_string();
    } 
    
    $result->close();
    $con->close();
    
    $tpl = new TemplateEngine("./html/map.html", array("map_points" => $str));
    $tpl->output_to_response();
}

/** 
 * 
 * Metoda presupune existenta unui parametru GET punct_id, altfel va incerca 
 * sa afiseze punctul cu ID-ul 1, daca exista.
 */
function show_point($con) {
	$p = new Punct($con);
	$id = 1;
	if (isset($_GET['punct_id'])) {
		$id = $_GET['punct_id'];
	}
	
	$p->get_by_id($id);
	
    $tpl = new TemplateEngine("./html/map.html", array("map_points" => $p->get_js_string()));
    $tpl->output_to_response();
}

/**
 * 
 * Metoda face modificare / adaugare de punct nou, in functie de existenta parametrului 
 * GET punct_id 
 * @param MySQLi $con
 */
function edit_point($con) {
	$values_to_check = array("long", "lat", "ssid");
	$context = array();
	
	
	if (isset($_GET['punct_id'])) {
		$p = new Punct($con);
		$p->get_by_id($_GET['punct_id']);
		$context['action'] = "index.php?action=edit&punct_id=".$p->id; 
	} else {
		$p = null;
		$context['action'] = "index.php?action=edit"; 
	}
	
	if (isset($_POST['submit_button'])) {
		$error = False;
		foreach ($values_to_check as $v) {
			if (!isset($_POST[$v]) || strlen($_POST[$v]) == 0) {
				$context[$v.'-err'] = "error";
				$error = True;
			} else {
				$context[$v.'-err'] = "";
			}
		}
		
		if (!$error) {
			if ($p == null) {
				$p = new Punct($con, $_POST['long'], $_POST['lat'], $_POST['ssid']);
			} else {
				$p->long = $_POST['long'];
				$p->lat = $_POST['lat'];
				$p->ssid = $_POST['ssid'];
			}
			
			$p->save();
			
	    	$tpl = new TemplateEngine("./html/map.html", array("map_points" => $p->get_js_string()));
	    	return $tpl->output_to_response();
		}
	} else {
		foreach ($values_to_check as $v) {
			$context[$v.'-err'] = "";
		}
	}

	if (isset($_GET['punct_id'])) {
		$data = array("long" => $p->long, "lat" => $p->lat, "ssid" => $p->ssid);
	} else {
		$data = array("long" => "", "lat" => "", "ssid" => "");
	}
	$context = array_merge($context, $data);
	$tpl = new TemplateEngine("./html/form.html", $context);
	return $tpl->output_to_response();		
}

function delete_point($con) {
	if (!isset($_GET['punct_id'])) {
		die("Trebuie parametrul GET punct_id");
	}

	$p = new Punct($con);
	$p->get_by_id($_GET['punct_id']);

	if (isset($_POST['submit_button'])) {
		$p->delete();
		return show_map_points($con);
	}
	
	$tpl = new TemplateEngine("./html/delete_form.html", array("action" => "index.php?action=delete&punct_id=".$p->id));
	return $tpl->output_to_response();
}

?>